#include <iostream>
#include <fstream>
#include <sstream>
#include <memory>

#include "graph.hpp"

void compute_reachable_nodes(Graph const & graph, Graph::NodeId start_node);


std::auto_ptr<Graph> read_file(std::string filename)
{
   std::fstream file(filename.c_str());
   if (not file) return std::auto_ptr<Graph>();
   Graph::NodeId nodes;
   file >> nodes;
   std::auto_ptr<Graph> graph(new Graph(nodes));
   std::string line;
   std::getline(file, line);
   while (std::getline(file, line)) {
      Graph::NodeId head, tail;
      std::stringstream ss(line);
      ss >> tail;
      if (not ss) return std::auto_ptr<Graph>();
      ss >> head;
      if (not ss) return std::auto_ptr<Graph>();
      graph->add_edge(tail, head);
   }
   return graph;
}


int main(int argc, char ** argv)
{
   std::auto_ptr<Graph> graph;
   if (argc == 2) {
      graph = read_file(argv[1]);
      if (graph.get() == NULL) {
         std::cerr << "Could not read graph from file: " << argv[1] << "\n";
         return 1;
      }
   }

   if (graph.get() == NULL) {
      std::cerr << "Usage: " << argv[0] << " filename\n";
      return 1;
   }

   compute_reachable_nodes(*graph, 0);
}
