#include <algorithm>
#include <iostream>
#include <stack>

#include "graph.hpp"


void compute_reachable_nodes(Graph const & graph, Graph::NodeId start_node)
{
   std::vector<Graph::NodeId> reachable_nodes;
   std::vector<bool>          visited(graph.num_nodes(), false);
   std::stack<Graph::NodeId>  stack;

   stack.push(start_node);
   while (not stack.empty()) {
      Graph::NodeId current = stack.top();
      stack.pop();
      if (visited[current]) {
         continue;
      }
      visited[current] = true;
      reachable_nodes.push_back(current);
      for (Graph::EdgeId edge = 0; edge < graph.num_outgoing_edges(current); ++edge) {
         stack.push(graph.outgoing_edge_head(current, edge));
      }
   }

   std::sort(reachable_nodes.begin(), reachable_nodes.end());

   std::cout << "Reachable nodes from node " << start_node << ":\n";
   for (std::size_t i = 0; i != reachable_nodes.size() - 1; ++i) {
      std::cout << reachable_nodes[i] << ", ";
   }
   //start_node is always member of reachable_nodes therefore no out-of-bound
   //access here.
   std::cout << reachable_nodes.back() << "\n";
}
